#!/bin/tcsh -f

set indir = outkrig1
set outdir = eta1

mkdir $outdir

foreach station (`tail -n +2 station.data | cut -f 1 -d \  `)
  echo $station
  grep $station $indir/* > temp
  if (! -z temp) then
    cut -f 2- -d ' '  temp > temp.data
    cut -f 2 -d / temp | cut -f 1 -d : > temp.date
    cut -b 1-4 temp.date > temp.year
    cut -b 5-6 temp.date > temp.month
    echo "year mo zed etazed eta" > $outdir/$station
    paste -d ' ' temp.year temp.month temp.data >> $outdir/$station
  endif
  rm temp*
end

